#include "commonheaders.h"
#include "cls-menu.h"

MenuItem::MenuItem(char *text, void (*funct)(void)) {
    ref = NULL;
    label = text;
    flag = false;
    hover = false;
    check = false;
    pressed = false;
    this->funct = funct;
}
MenuItem::~MenuItem() {
    ;
}
bool MenuItem::Check(short xLocation, short yLocation, short width) {
    if(mouse_inarea(xLocation - 4, 16 + (yLocation * 16), width + 35, 15) && strcasecmp(label, "&sep") != 0) {
        hover = true;
        if(mouse_b & 1) {
            pressed = true;
        } else {
            if(pressed) {
                funct();
                if(flag) {
                    if(ref != NULL) {
                        if(*ref) {
                            *ref = true;
                        } else {
                            *ref = false;
                        }
                    } else {
                        if(!check) {
                            check = true;
                        } else {
                            check = false;   
                        }
                    }
                }
                pressed = false;
                return true;
            }
        }
    } else if(strcasecmp(label, "&sep") != 0) {
        hover = false;
        if(pressed) pressed = false; 
    }
    return false;
}
void MenuItem::Flagged(bool checked, bool *refvar) {
    flag = true;
    ref = refvar;
    check = checked;
}
bool MenuItem::Separator(void) {
	if(!strcasecmp(label, "&sep")) return true;
	else return false;
}
void MenuItem::Draw(BITMAP *output, short xLocation, short yLocation, short width) {
    if(strcasecmp(label, "&sep") != 0) {
		if(hover) {
        	//rectfill(output, xLocation - 15, yLocation - 3, xLocation + width + 18, yLocation + 10, makecol(128, 128, 128));
        	draw_hbar_gradient(output, xLocation - 15, yLocation - 3, width + 33, 14, WIN_COLOUR3, WIN_COLOUR4);
        	rect(output, xLocation - 16, yLocation - 4, xLocation + width + 19, yLocation + 11, WIN_COLOUR4);
        	textprintf(output, font, xLocation + 1, yLocation + 1, WHITE, label);
        	textprintf(output, font, xLocation, yLocation, BLACK, label);
    	} else {
    	    textprintf(output, font, xLocation + 1, yLocation + 1, BLACK, label);
    	    textprintf(output, font, xLocation, yLocation, WHITE, label);
    	}
    	if(flag) {
    	    if(ref != NULL) {
    	        if(*ref) draw_sprite(output, checkmark, xLocation - 10, yLocation);
    	    } else if(check) {
    	        draw_sprite(output, checkmark, xLocation - 10, yLocation);
    	    }
    	}
	} else {
		hline(output, xLocation - 11, yLocation + 2, xLocation + width + 14, makecol(255, 255, 255));
		hline(output, xLocation - 11, yLocation + 3, xLocation + width + 14, makecol(32, 32, 32));
		hline(output, xLocation - 11, yLocation + 5, xLocation + width + 14, makecol(255, 255, 255));
		hline(output, xLocation - 11, yLocation + 6, xLocation + width + 14, makecol(32, 32, 32));
	}
}


MenuDir::MenuDir(char *text, short xLocation) {
    items = 0;
    active = false;
    hover = false;
    xPos = xLocation;
    
    label = NULL;
    label = (char *)malloc(strlen(text)+1);
    Init_String(label, text, strlen(text)+1);

    width = strlen(text) * 8 + 16;
    MenuItems = NULL;
}
MenuDir::~MenuDir() {
    for(short i = 0; i < items; i++) {
        //MenuItems->~MenuItem[i]();
        delete(MenuItems[i]);
    }
    free(label);
}
bool MenuDir::AddItem(char *text, void (*funct)(void)) {
    MenuItems = (MenuItem **)qualloc(MenuItems, sizeof(MenuItem *) * (items + 1));
    MenuItems[items] = new MenuItem(text, funct);
    if(MenuItems[items] == NULL) {
        return false;
    }
    items ++;
    if(strlen(text) * 8 > width) width = strlen(text) * 8;
    return true;
}
bool MenuDir::Check(void) {
    if(mouse_inarea(xPos - 5, 0, (strlen(this->label) * 8) + 4, 15)) {
        if(mouse_b & 1) {
            active = true;
        }
        hover = true;
    } else {
        if(active && mouse_inarea(xPos - 5, 16, width + 37, (items * 16) + 10)) {
            short i;
            for(i = 0; i < items; i ++) {
                if(MenuItems[i]) {
                    if(MenuItems[i]->Check(xPos, i, width)) {
                        active = false;
                    }
                }
            }
        } else {
            if(mouse_b & 1) {
                active = false;
            }
        }
        hover = false;
    }
    if(active) {
        short i;
        for(i = 0; i < items; i ++) {
            if(MenuItems[i]) {
               MenuItems[i]->Check(xPos, i, width);
            }
        }
    }
    return active;
}
void MenuDir::Flagged(bool checked, bool *refvar) {
    if(MenuItems[items - 1]) {
        MenuItems[items - 1]->Flagged(checked, refvar);
    }
}
void MenuDir::Draw(BITMAP *output) {
    if(hover) {
        //rectfill(output, xPos - 3, 2, xPos + (strlen(this->label) * 8) + 2, 14, makecol(128, 128, 128));
        draw_hbar_gradient(output, xPos - 3, 2, (strlen(this->label) * 8) + 5, 14, WIN_COLOUR3, WIN_COLOUR4);
        rect(output, xPos - 4, 1, xPos + (strlen(this->label) * 8) + 3, 15, WIN_COLOUR4);
        textprintf(output, font, xPos + 1, 5, WHITE, label);
        textprintf(output, font, xPos, 4, BLACK, label);   
    } else {
        textprintf(output, font, xPos + 1, 5, BLACK, label);
        textprintf(output, font, xPos, 4, WHITE, label);
    }
    
    if(active) {
        rect(output, xPos - 5, 0, xPos + (strlen(label) * 8) + 4, 16, BLACK);
        //rectfill(output, xPos - 5, 16, xPos + width + 32, 16 + (items * 16), WIN_COLOUR);
        draw_hbar_gradient(output, xPos - 5, 16, width + 37, items * 16 + 1, WIN_COLOUR, WIN_COLOUR2);
        rect(output, xPos - 5, 16, xPos + width + 32, 17 + (items * 16), BLACK);
        
        short i;
        for(i = 0; i < items; i ++) {
            if(MenuItems[i]) {
                MenuItems[i]->Draw(output, xPos + 12, 21 + i * 16, width);
            }
        }
    }
}


Menu::Menu(void) {
    dirs = 0;
    xPos = 12;
    MenuDirs = NULL;
}
Menu::~Menu() {
    for(short i = 0; i < dirs; i++) {
        delete(MenuDirs[i]);
    }
}
bool Menu::AddDir(char *text) {
    if(debug) 
    {
        logputs("\t\tCreating \"");
        logputs(text);
        logputs("\" Menu...");
    }
    MenuDirs = (MenuDir **)qualloc(MenuDirs, sizeof(MenuDir *) * (dirs + 1));
    MenuDirs[dirs] = new MenuDir(text, xPos);
    xPos += strlen(text) * 8 + 12;
    dirs ++;
    if(debug) logputs("Success.\n");
    return true;
}
bool Menu::AddItem(char *text, void (*funct)(void)) {
    if(MenuDirs[dirs - 1]) {
        return MenuDirs[dirs - 1]->AddItem(text, funct);
    }
    return false;
}
bool Menu::Check(void) {
    short i;
    bool active = false;
    for(i = 0; i < dirs; i ++) {
        if(MenuDirs[i]) {
            if(MenuDirs[i]->Check()) {
                active = true;
            }
        }
    }
    return active;
}
void Menu::Flagged(bool checked, bool *refvar) {
    if(MenuDirs[dirs - 1]) {
        MenuDirs[dirs - 1]->Flagged(checked, refvar);
    }
}
void Menu::Draw(BITMAP *output) {
    //rectfill(output, 0, 0, WIN_WIDTH, 16, WIN_COLOUR);
    draw_hbar_gradient(output, 0, 0, main_width, 17, WIN_COLOUR, WIN_COLOUR2);
    //draw_hbar_gradient(output, 0, 12, WIN_WIDTH, 4, WIN_COLOUR2, WHITE);
    //hline(output, 0, 16, WIN_WIDTH, WHITE);
    
    short i;
    for(i = 0; i < dirs; i ++) {
        if(MenuDirs[i]) {
            MenuDirs[i]->Draw(output);
        }
    }
}

